(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    106675,       2357]
NotebookOptionsPosition[     98380,       2151]
NotebookOutlinePosition[     98766,       2167]
CellTagsIndexPosition[     98723,       2164]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 141 - Calculus I with Mathematica", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 3.713235386162277*^9}, {3.714348030373366*^9, 
  3.71434804088516*^9}},ExpressionUUID->"ea3ae075-e13d-45da-9c58-\
fc7d61cf0945"],

Cell[CellGroupData[{

Cell[TextData[{
 "Functions\n",
 StyleBox["September 14, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}, {3.7136367302253275`*^9, 3.7136367303689313`*^9}, {
  3.7136390134313707`*^9, 3.713639019486205*^9}, {3.7138289066862593`*^9, 
  3.713828911468053*^9}, {3.714057515975712*^9, 3.7140575196396585`*^9}, {
  3.714251590010911*^9, 3.7142515958496876`*^9}, {3.71434805393347*^9, 
  3.7143480573656034`*^9}},ExpressionUUID->"5f63ec64-10be-4193-908b-\
b78eee0eae7b"],

Cell["\<\
To begin typing code below a problem, move the cursor to where you want to \
enter code and look for when the cursor turns horizontal. Click there and you \
can start typing. If you want to type in plain text (instead of code), once \
you\[CloseCurlyQuote]ve clicked to start the new line, you will see a + on \
the left side of the line. Click that, and select \
\[OpenCurlyDoubleQuote]Plain Text\[CloseCurlyDoubleQuote] to type normally.\
\>", "Text",
 CellChangeTimes->{{3.7143481917179546`*^9, 
  3.7143482799761105`*^9}},ExpressionUUID->"22f8fbfb-02d0-4651-926a-\
99c2a7d90e85"],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"03899cad-2d7f-4aa5-9757-\
7093b5aa4e28"],

Cell["Find the domain of the function", "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.713828982326439*^9}, {
   3.7140575793278756`*^9, 3.714057604512898*^9}, {3.714251724130576*^9, 
   3.7142517519477997`*^9}, {3.7142583209982357`*^9, 
   3.7142583534768305`*^9}, {3.7143481249661684`*^9, 
   3.7143481344418764`*^9}},ExpressionUUID->"730a487e-f633-46f1-aa76-\
0a648394cc42"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"h", "(", "x", ")"}], "=", 
   SqrtBox[
    RowBox[{"16", "-", 
     SuperscriptBox["x", "2"]}]]}], TraditionalForm]],
 FormatType->"TraditionalForm",
 FontSize->16,ExpressionUUID->"1131da39-6451-449d-b9ff-e9f3e804ffd2"]], "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.713828982326439*^9}, {
   3.7140575793278756`*^9, 3.714057604512898*^9}, {3.714251724130576*^9, 
   3.7142517519477997`*^9}, {3.7142583209982357`*^9, 
   3.7142583534768305`*^9}, {3.7143481249661684`*^9, 
   3.7143481645746875`*^9}, {3.7143493621070585`*^9, 3.7143493656914787`*^9}},
 TextAlignment->Center,ExpressionUUID->"d5621506-ef64-492c-ae8c-62c837cb3556"],

Cell[TextData[{
 "Graph the function on it\[CloseCurlyQuote]s whole domain using the ",
 StyleBox["Plot", "Code"],
 " command. Remember that as you start typing \[OpenCurlyDoubleQuote]Plot\
\[CloseCurlyDoubleQuote], Mathematica will give you an option to autocomplete \
the command and if you click the i with a circle around it next to the \
command name, it will give you instructions on how to use the command."
}], "Text",
 CellChangeTimes->{{3.7143493451274185`*^9, 
  3.714349462474391*^9}},ExpressionUUID->"ebf2fcd9-3071-4167-9be2-\
815e89dca293"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147808400090866`*^9, 
  3.714780842050908*^9}},ExpressionUUID->"39a66b88-c47e-4418-99d3-\
2b1c8d7303c9"],

Cell[TextData[{
 "The piece of the function under the square root must be greater than or \
equal to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b669c1f2-fd2f-42af-96ff-7416b29ad6c2"],
 ", so we get"
}], "Text",
 CellChangeTimes->{{3.7147808400090866`*^9, 3.7147808407362747`*^9}, {
  3.714782003963497*^9, 
  3.7147820283980436`*^9}},ExpressionUUID->"dcb9072c-3c9f-4d30-a012-\
1979efa045e4"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"16", "-", 
     SuperscriptBox["x", "2"]}], "\[GreaterEqual]", 
    RowBox[{"0", " ", "\[DoubleLongRightArrow]", "16"}], "\[GreaterEqual]", 
    RowBox[{
     SuperscriptBox["x", "2"], "\[DoubleLongRightArrow]", "4"}], 
    "\[GreaterEqual]", "x", "\[GreaterEqual]", 
    RowBox[{"-", "4"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4eb2c675-e8fa-4c61-83a5-fb287af91ba0"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "4"}], "]"}], TraditionalForm]],
  TextAlignment->Center,
  FormatType->"TraditionalForm",ExpressionUUID->
  "717872a1-e355-4341-865d-d031d8e165ff"]
}], "Text",
 CellChangeTimes->{{3.7147808400090866`*^9, 3.7147808407362747`*^9}, {
  3.714782003963497*^9, 3.714782097688691*^9}},
 TextAlignment->Center,ExpressionUUID->"bdbdd5db-077b-447d-8a72-64a28c273eb9"],

Cell[TextData[{
 "When we plot the function, we\[CloseCurlyQuote]ll let the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c45ee5e7-6168-42cd-80c3-1cf23411517f"],
 "-values range over the whole domain of ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "90997003-6552-4f43-b089-c3bf86d2c877"],
 ":"
}], "Text",
 CellChangeTimes->{{3.714782143656804*^9, 
  3.7147821632606363`*^9}},ExpressionUUID->"693e376a-60ee-4337-aa73-\
b3f48c28f321"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"16", "-", 
     SuperscriptBox["x", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147821206374197`*^9, 
  3.714782141218435*^9}},ExpressionUUID->"48897f7f-510c-4e10-afde-\
6e84ac293be7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw12Hk8VN//B3BEtpm5Emm1pJQlKVtC54hIJfGhRBIh2YpkKSSp0CYUWSuF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       "]]},
     Annotation[#, "Charting`Private`Tag$10862#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {0., 3.9999999526113403`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.714782167550609*^9},ExpressionUUID->"d5474044-01e0-4594-a61e-\
b395854104b9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    SuperscriptBox["x", "3"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "27e58f84-d279-4b7c-b947-c3a4dbd936ed"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "=", 
    RowBox[{"sin", " ", "x"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7e04a712-9a78-403e-a179-e074190dbc5a"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"h", "(", "x", ")"}], "=", 
    SqrtBox["x"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1953ed69-d675-4b4b-9e72-25cfe64e4d07"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 
   3.7143503627327375`*^9}},ExpressionUUID->"4e87d379-fa88-4a7f-916a-\
cc55458345d6"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "(", 
    RowBox[{"f", "(", "x", ")"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b882c097-56c9-49ee-9c5f-3ced940004f7"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 
   3.714350376145939*^9}},ExpressionUUID->"51b692b4-cfee-4a37-b25d-\
cff8ce6705ba"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "\[SmallCircle]", "f"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "adce5f47-299b-466e-8597-7da9b26587a8"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143504940026965`*^9}},ExpressionUUID->"aa46eced-38f6-4d52-ae48-\
c9bd4c56f9fc"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "\[SmallCircle]", "g"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9b94770b-cbab-40db-869e-2dba97dddf99"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143505074749603`*^9}},ExpressionUUID->"08d8f2db-42e7-46de-a664-\
df84e17fd7fa"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"h", "\[SmallCircle]", "g", "\[SmallCircle]", "f"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4b5e2f30-b239-4363-8cad-8ff4abb107e9"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143505272968445`*^9}},ExpressionUUID->"376ceaf0-9116-4b4b-b4ef-\
ceda61e26454"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147831867552757`*^9, 
  3.7147831874673023`*^9}},ExpressionUUID->"006ecde4-e925-4795-8acc-\
ac09a12d4b43"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"h", "(", 
    RowBox[{"f", "(", "x", ")"}], ")"}], "=", 
   RowBox[{
    SqrtBox[
     SuperscriptBox["x", "3"]], "=", 
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]]}]}], 
  TraditionalForm]],ExpressionUUID->"41d4f8dd-7f3c-48a4-95d9-fbb166dda39f"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350376145939*^9}, {3.714784186308402*^9, 
   3.7147842136069107`*^9}},ExpressionUUID->"5f04b1fe-5046-4be6-8c0c-\
740cbfa17b1c"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "\[SmallCircle]", "f"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], "=", 
   RowBox[{"sin", "(", 
    SuperscriptBox["x", "3"], ")"}]}], 
  TraditionalForm]],ExpressionUUID->"ebd71091-2626-4166-a845-12fb6c5fcf49"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143504940026965`*^9}, {3.71478421793303*^9, 
   3.7147842291256995`*^9}},ExpressionUUID->"c93a68c2-09ac-47aa-bbfc-\
c9702c914080"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "\[SmallCircle]", "g"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], "=", 
   RowBox[{
    SuperscriptBox["sin", "3"], "x"}]}], 
  TraditionalForm]],ExpressionUUID->"0cf9b6c3-2b3b-4934-ba61-15a9d9089517"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143505074749603`*^9}, {3.7147842335000315`*^9, 
   3.7147842406309776`*^9}},ExpressionUUID->"7f6bfa96-7957-4947-9313-\
5fd30e6159f3"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"h", "\[SmallCircle]", "g", "\[SmallCircle]", "f"}], ")"}], 
    RowBox[{"(", "x", ")"}]}], "=", 
   SqrtBox[
    RowBox[{"sin", "(", 
     SuperscriptBox["x", "3"], ")"}]]}], 
  TraditionalForm]],ExpressionUUID->"a7cf36c7-0b67-4928-a448-303539a21831"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7143503187599497`*^9, 3.714350423200905*^9}, {3.714350487660966*^9, 
   3.7143505272968445`*^9}, {3.714784245045039*^9, 
   3.7147842579269743`*^9}},ExpressionUUID->"52b71f1d-0b7c-4907-9948-\
d97ca28c05d8"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell[TextData[{
 "Compute both difference quotients for the function ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], "=", 
     FractionBox["7", 
      RowBox[{"x", "+", "3"}]]}],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->9,ExpressionUUID->"9ab34efe-a287-4785-9ab1-841813aea857"],
 "."
}], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 3.7140589627666883`*^9}, 
   3.7140589981439013`*^9, {3.714251939812981*^9, 3.7142520192698393`*^9}, {
   3.7143506148735065`*^9, 3.71435064006275*^9}, 
   3.7143506814102297`*^9},ExpressionUUID->"cf8a23bc-068d-427d-bf40-\
717ca9e27e42"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714790825242773*^9, 
  3.7147908275999403`*^9}},ExpressionUUID->"242e5402-30de-4021-b980-\
2d3f0876a528"],

Cell["\<\
Since we\[CloseCurlyQuote]ve now computed a few difference quotients by hand, \
here is a use of Mathematica to make the simplification easier:\
\>", "Text",
 CellChangeTimes->{{3.714790825242773*^9, 
  3.714790875124524*^9}},ExpressionUUID->"015cff35-61d2-426c-8915-\
03383c4754b0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   FractionBox["7", 
    RowBox[{"x", "+", "3"}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.714790881562271*^9, 
  3.7147909443506904`*^9}},ExpressionUUID->"6a552fbd-17c5-4c1b-9c69-\
f9a588a8a715"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", "+", "h"}], "]"}], "-", 
    RowBox[{"f", "[", "x", "]"}]}], "h"], "]"}]], "Input",
 CellChangeTimes->{{3.714790950823132*^9, 
  3.714790969461609*^9}},ExpressionUUID->"e11582f8-a4ec-4b1d-806a-\
8cef1d8c1f14"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["7", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "h", "+", "x"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.7147909576224775`*^9, 
  3.71479097051416*^9}},ExpressionUUID->"a3bbfa5a-78bc-41a4-8c03-\
6dbf1d030173"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "-", 
    RowBox[{"f", "[", "a", "]"}]}], 
   RowBox[{"x", "-", "a"}]], "]"}]], "Input",
 CellChangeTimes->{{3.714790989103464*^9, 
  3.7147910142711515`*^9}},ExpressionUUID->"aa0f7d47-a729-421b-99ab-\
fba2c32deb89"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["7", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "+", "a"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.7147910159238997`*^9},ExpressionUUID->"6c12d494-7fc9-440e-bec5-\
57d7e21f4518"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 3.7132360046164513`*^9}, {
  3.7142519994689074`*^9, 
  3.714252000372249*^9}},ExpressionUUID->"62b50a9e-7116-4577-a2ef-\
50a12b356e7b"],

Cell[TextData[{
 "Use the graph of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"cos", " ", 
     RowBox[{"(", 
      RowBox[{"3", "x"}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "77975667-6448-4e60-8e5d-262bc0889154"],
 " to check for any symmetry. Is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", 
    RowBox[{"3", "x"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "13a9553a-231c-4949-9f3c-e3c866c93225"],
 " an even or odd function? To graph trigonometric functions using \
Mathematica, enter their name with capital letters. For example, you would \
insert ",
 StyleBox["Cos[3x]", "Code"],
 " into the plot command to plot this function."
}], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.713833157380231*^9}, {3.7140591051033754`*^9, 3.7140591641839914`*^9}, {
   3.714060409067382*^9, 3.7140604184432797`*^9}, {3.71425294893425*^9, 
   3.714253001774125*^9}, {3.714253213451623*^9, 3.714253214323145*^9}, {
   3.714350704226018*^9, 
   3.7143508068427696`*^9}},ExpressionUUID->"2f2e5219-46fb-48a7-8503-\
ad860214b448"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147842751650405`*^9, 
  3.7147842768321247`*^9}},ExpressionUUID->"2854bd76-3384-4fe3-b5ba-\
7aca60a6bdbb"],

Cell["First graph the function", "Text",
 CellChangeTimes->{{3.7147842751650405`*^9, 
  3.7147842815569487`*^9}},ExpressionUUID->"0ad61283-0ade-43ea-a4d7-\
66bab6b3acdf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"3", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147842875676203`*^9, 
  3.714784363214464*^9}},ExpressionUUID->"9da07e30-48aa-4040-b169-\
9be3dc5b4cb4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw1e3k0Vd/7/73GKyqhFJXqXTIlSSrJcyQyNKBIMyo0aTCkUCppIBGZU5lS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       "]]},
     Annotation[#, "Charting`Private`Tag$11093#1"]& ]}, {}, {}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->
   NCache[{{-Pi, Pi}, {-0.9999999999999261, 
     0.9999989476587114}}, {{-3.141592653589793, 
    3.141592653589793}, {-0.9999999999999261, 0.9999989476587114}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7147843479305563`*^9, 
  3.7147843636671896`*^9}},ExpressionUUID->"0d4b38e0-d8f1-4eef-a87f-\
11bc68f04c91"]
}, Open  ]],

Cell[TextData[{
 "Since this function is symmetric about the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e46a0e4d-0bee-42e2-8685-014ecd571430"],
 "-axis, we can see that it is an even function."
}], "Text",
 CellChangeTimes->{{3.71478436843634*^9, 
  3.7147843878238916`*^9}},ExpressionUUID->"1ce838d9-be03-46ad-87e8-\
2ff45dc35a4e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7140619948143387`*^9, 
  3.71406199930182*^9}},ExpressionUUID->"51845899-4359-4829-b905-\
84276d313cc9"],

Cell[TextData[{
 "Solve for ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6b5b27e9-a03d-404d-b573-c96e14a71e16"],
 " in the equation"
}], "Text",
 CellChangeTimes->{
  3.714254557382414*^9, {3.7142567514087563`*^9, 3.7142568440153804`*^9}, {
   3.7143508408683214`*^9, 
   3.7143508507573977`*^9}},ExpressionUUID->"711c36cb-75bb-4f3b-970f-\
df51bdefe6eb"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"48", "=", 
    RowBox[{"6", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"4", "k"}]]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "286acdfc-a7ad-4e00-98ff-9bfe22a84929"],
 "."
}], "Text",
 CellChangeTimes->{
  3.714254557382414*^9, {3.7142567514087563`*^9, 3.7142568440153804`*^9}, {
   3.7143508408683214`*^9, 3.714350877164486*^9}},
 TextAlignment->Center,ExpressionUUID->"1ca9834f-eccd-44d2-acf7-dfa223dc474f"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714792050894165*^9, 
  3.7147920528481703`*^9}},ExpressionUUID->"f5c74c01-3592-4a84-a956-\
d7a5da814fdd"],

Cell[TextData[{
 "We need to isolate ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ee84c5d3-cd31-4acd-8b25-2828e2b8c119"],
 ". To do this, begin by dividing by ",
 Cell[BoxData[
  FormBox["6", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "bfd72b3c-39e1-4132-9c95-f8ca1d1e47f8"],
 " to get: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"8", "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"4", "k"}]]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3bb5f1fc-5212-4ef3-a70a-54f5afba3e18"],
 ". Now, we must take the natural log of both sides: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", " ", "8"}], "=", 
    RowBox[{
     RowBox[{"ln", "(", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", "k"}]], ")"}], "=", 
     RowBox[{"4", "k"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "cb6f81ee-e71b-4c80-bed1-c04b41c4b342"],
 ". Then, divide by ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5308b339-53ed-49f3-9000-5c9832100619"],
 " to get ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", 
    StyleBox[
     FractionBox[
      RowBox[{"ln", " ", "8"}], "4"],
     FontSize->18]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e2b82957-1d93-41b6-965d-1715e841c66e"],
 "."
}], "Text",
 CellChangeTimes->{{3.714792050894165*^9, 
  3.7147921511274104`*^9}},ExpressionUUID->"e3f3f7eb-f9ed-4ab0-bb5c-\
abb20d6595b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9, {3.7140621526354446`*^9, 3.714062155403966*^9}, 
   3.7140622114516797`*^9},ExpressionUUID->"d2ec5041-3f61-4ae8-8bcc-\
02c6dd814afa"],

Cell[TextData[{
 "Solve for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5308e199-4c32-4de6-b3ab-8df6d32db378"],
 " in the equation"
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, 3.7138339340870676`*^9, {
   3.7140612265715113`*^9, 3.714061277211094*^9}, {3.714068124440487*^9, 
   3.714068133768079*^9}, {3.7142545621066675`*^9, 3.7142546339231057`*^9}, 
   3.7142568936071067`*^9, 3.7143508902764444`*^9, {3.714351455910578*^9, 
   3.7143514679286785`*^9}},ExpressionUUID->"1420c7a4-a1a3-4361-91a6-\
56bd79902e51"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"ln", " ", 
      SuperscriptBox["x", "2"]}], " ", "+", " ", 
     RowBox[{"3", "ln", " ", "x"}]}], " ", "=", " ", 
    RowBox[{"ln", " ", "32"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "927c0927-1e78-4b07-ba11-f8f67479921d"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, 3.7138339340870676`*^9, {
   3.7140612265715113`*^9, 3.714061277211094*^9}, {3.714068124440487*^9, 
   3.714068133768079*^9}, {3.7142545621066675`*^9, 3.7142546339231057`*^9}, 
   3.7142568936071067`*^9, 3.7143508902764444`*^9, {3.714351455910578*^9, 
   3.714351513863181*^9}},
 TextAlignment->Center,ExpressionUUID->"c52db8da-e799-4ff8-8cb2-2da33e9e5303"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147864005824513`*^9, 
  3.714786402603528*^9}},ExpressionUUID->"a179073b-ea23-4d7a-a785-\
013b7fe7f02f"],

Cell[TextData[{
 "Lets work on first combining the left side into one logarithm: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"ln", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"3", "ln", " ", "x"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"ln", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"ln", " ", 
       SuperscriptBox["x", "3"]}]}], "=", 
     RowBox[{
      RowBox[{"ln", "(", 
       RowBox[{
        SuperscriptBox["x", "2"], 
        SuperscriptBox["x", "3"]}], ")"}], "=", 
      RowBox[{"ln", "(", 
       SuperscriptBox["x", "5"], ")"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "09191a26-686b-4322-ba59-3f6e2b423b67"],
 " so we have ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", "(", 
     SuperscriptBox["x", "5"], ")"}], "=", 
    RowBox[{"ln", " ", "32"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "394f020c-a131-4e07-befa-82d2befd4c6e"],
 ". This means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "5"], "=", "32"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c0dc52cb-1881-4474-a81e-6d856951112b"],
 " which implies ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RadicalBox["32", "5"], "=", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4985b3af-b901-4591-a9dc-89c28fda60c4"],
 "."
}], "Text",
 CellChangeTimes->{{3.714791065724086*^9, 
  3.714791188110909*^9}},ExpressionUUID->"f2e21425-9fba-442d-b5ff-\
8d824f1f7f7c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.7142569274923954`*^9, 
  3.714256930117067*^9}},ExpressionUUID->"5cd38511-aaaa-471e-ac17-\
065388224828"],

Cell[TextData[{
 "Use the graph of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", 
      SuperscriptBox["x", "2"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6b1a2441-5235-4cdf-bf89-c8bbaeb71ca3"],
 " to determine the largest intervals on which the function has an inverse. \
(Remember, for a function to have an inverse, it needs to be one-to-one, \
i.e., it needs to pass the horizontal line test.)"
}], "Text",
 CellChangeTimes->{{3.7142569274923954`*^9, 3.7142569600462046`*^9}, {
  3.7143515340232353`*^9, 
  3.7143516128957644`*^9}},ExpressionUUID->"b6d95d74-515d-490f-943d-\
ed8dbad62f1c"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147853022301064`*^9, 
  3.7147853040504417`*^9}},ExpressionUUID->"5f0ae938-3588-4145-aacf-\
205eae602a57"],

Cell["Begin by plotting the function", "Text",
 CellChangeTimes->{{3.714785312040012*^9, 
  3.714785316462492*^9}},ExpressionUUID->"2afefba1-cff2-4c09-b1b8-\
392beaa99a5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"3", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147853190806885`*^9, 
  3.714785334602681*^9}},ExpressionUUID->"3ebc1d57-4110-4e3b-8461-\
ddc8e27ee4e5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3k4VV8Xx6/pmq57kJSSoVQSkqFSsY8ikkSklERUGpQkUab6SUgZMySF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       "]]},
     Annotation[#, "Charting`Private`Tag$11137#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 5}, {-19.999996571428756`, 24.070509432498476`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7147853362328625`*^9},ExpressionUUID->"9d88704b-f032-458e-b5ae-\
40294e728d3e"]
}, Open  ]],

Cell[TextData[{
 "There are three \[OpenCurlyDoubleQuote]largest\[CloseCurlyDoubleQuote] \
intervals on which is function be made one-to-one: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Infinity]"}], ",", "0"}]}], "]"}], ",", " ", 
     RowBox[{"[", 
      RowBox[{"0", ",", "2"}], "]"}], ",", " ", 
     RowBox[{"[", 
      RowBox[{"2", ",", "\[Infinity]"}]}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "68a7988b-65f4-4630-aeba-2659d502867a"],
 ". Here is a graph of the function colored according to these three pieces:"
}], "Text",
 CellChangeTimes->{{3.7147855790119495`*^9, 3.7147856328113956`*^9}, {
  3.7147921694319973`*^9, 
  3.7147921965127134`*^9}},ExpressionUUID->"93feaaaf-89f1-4a58-8b3d-\
4dc471fe3973"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "20"}], ",", "30"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.714792205042039*^9, 
  3.71479229613041*^9}},ExpressionUUID->"311900b0-7a16-469a-b4f5-\
c88faa08ed93"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVlPk71AsDRxV1yxKVEIkkhBJDylLokkqkK0o3JNkqS120CiWTpWStjBpE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        "]]},
      Annotation[#, "Charting`Private`Tag$24605#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV0gk0VV0bB/CbhMQ9SPUqkgwpQ14JGXpUlCl9ZIi8IkQSQhmKKEMlUq8k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        "]]},
      Annotation[#, "Charting`Private`Tag$24646#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1gk0VVsfAPBzLpndczmmFCGilxCVW8r9G+KoKz5CVCrdF55QQqhMqYcm
QyrvaVQvhYyFTPuLTA1kSaYGkkQKZZ7efmets/b6rb322f9hn7OOuoe/w+8s
giDS8f3faJdhLIYH6F/476JQcPTooR6SgB2vpx7MY1/fnf26WoiA3CPJmdPY
Neu91t9bRIAaX5f8hf2ds/zvOFEC6p4vzxzAVhh8t+AjTgDa1Z7xHnvzs6uC
7ZIE6HpmTTViC2441htIE2DgOptWgX0ulK1HUwT0pukkPcAudKxPGuMQEHgt
oS0Zu3N1zMRbWQKGnyX7h2GzxHi7n8gREBuV6OyO/VvPFEpTIMDe5Os5HrZD
WaFWhBIBXu7TMqrYoZf94/crE0A4a36emqdQ3dbPjitUCRD2h6P3sYc1bxaL
qeH8Do7onsRWXHBTGVQnYPcHruF27IMFTX05WgSIEeIq/XMUunD+7LYkbQL4
4fZkHvYjT6vcwJX4eb9l6R3DFl5aFrphNV7/WMVjZpZCuuPB75foE7DJd/Rg
CbZj0xqLeQMCpOZ35gdi3465J1W1lgCOm6vypxkKmQ0l3eBvIkCn4LLKjWkK
edXaCuubErB2xHuLNXbCLTFvGSCA69Hw8NsUhT46hRu2WhBwMy7XQh87vML7
2d5tuD53owTJExT656rmb+a2BLww1PtTC/tlwIcLmnY4H/6BvsJxCi3Vdtr5
1YGAj696XZ6PUejJRRgMcCMg62XhWOtPCvV4z9g57cb9C5AfdMAWt3xcaOyO
95uZUnwxSqGdk6vCZ/fj/ni/kH88QqHxfYoyZ7wJKPYRSfD6QSEjw+/rU0MI
6Krkj1oNUOiBp5H+nTDcnyYj+s+vFNK4FqKdc4KANKeunqp+CsmKCSk9i8T5
2vPOGn2h0Og7xanhWJyP8LevA58olB9nVsqk4vrsbVtV0oX7X3mmwPFvAva1
D7VVdeJ6/nqe6X6NgDucGe3nHRRK2uucFniLAAHTkNHYRqGAdT4nb94nIKGz
QzW3hUKG3Zd4kyUEXDpdtvLVcxyfQoexUBnu3w/B5dsNOD7+MgN2BZ53N7l6
tB7HV3RfTfPpf+eDt1OyFsd3roK0byBg1suqQOYphfK4/VX3Ogi4mmimEVpE
IYMEE8ZlhoCy7pxt2TcoZDd9/CpvjgBLazV1vesU8hOU9WsvECBXdPVzZhqF
srib4yZZJJw4IrrheiqFdLpNG1IlSNgXdGdiTzKF1A3N+V2LSYh5q2JucwbH
08LY7+eS0DShEN7gTaE1pnE3bTbi+fzGkS+eFLLPqB9es4kES5cKHusgPr8n
tiaygIQu5XTP1R4UktDiN6dbk6Dz0OHNHjcKCQXb7ehzJuHQ8rOXV2yl0C9F
550+QSRwTf7QcNTG+Sodktt6jIT+xIDFCloUGlkc3aQTSsKsYH7sjQb+Hix5
yPSdIEH4oe4eviqFvi4T2bA/hoRqyZJmWp5C77UfL3ZJJoGY2PhaioXfR2OF
TvM8En4lG72+3c5GNVzdK+oFJBRfS2TIt2z0bIO5I/GIhMLElsTdLWz01MTv
eXkxCZoHU66IN7JROa+mlItI6CXa3DdXs1G+dXCaXiN+3ryEo+RDNvrbpXWP
8hAJHzVD/twUwUYDBcHZ6j9I0B34ITd6nI24HMU5nRESLn3jv0wPYaPWOpc0
4zESYm1SSmeOsJHsxvaOHXN4fX1QyEkBG8Uv7XK5KM2CNHpldS3DRmHd3f8T
1mPB0i2jOgFsNnLzGdry3Y8Fgu8dO0bPSyP72dih5sMsaDrGTRqLk0ZW5zVT
igJYEOh53HbstDQyzNnVGxnMgquyK0wGTkojyZ/10XQ4C3bWm3bf95VGZWH/
VHLPs2CH6UJ9BF8aqcbv3XAqE+8fVJcaJSqNujNe6yr1s0As+V1SSYAU0kmZ
8NQaYEFZhZq/n68U8otSSTf8xgKptaWzql5SaNrVe7HtMAs4vcU6R/dIITlJ
UiR6kgU3H63K/mIthRhfgw+DYkLQNJeYTyyVQrlrLiZWrhSCF8ohwkNIEkU+
4Y8f9BGCScbDN2pOArFiVj+y/yYEAv6+9glGHG071hmQIBCG/qypFJ/Doijb
VI0e6xMGnSHFpGqtRahV3zA/Z98iiE3wCr9XwkI9bfetFrUtgn4NLeetNIFE
nYvLI1xFILJZPUyiaqry52yykX2zCKBJ3vuVej8rJ4+JnNviJApqbTlVHnl9
lR8evG9/80YUCF1h9wxBbeUF0ZgVZbZiQHRz4w/7tPKcuMiptlEMbs6LjkVt
/MHrTao/pWMjDmrL/9iTmzvFO/d/70sPX4jD8GXd8HVFLFDI8P+r0VYCDETq
Dh/oFwPPYvMbVjUScDhZTn6QpuB1WtaZHkYSQrrjN99WpoGV+elQy1NJ0BEu
bVlyVwEUjkQy+zdKwccLZ+pIB2WwkCwUocukgBDvP3o3XhWMGwurlNdJA5I6
Gefkpg6WnvwD1sXSMBl5rE+7bDkYFdlMsjewofp497tla1fAgIHcOd08Ngy7
KwpP3dCBkvAglr8RBbkvq4VkPFaB/Xj6MdFsCpT2ypsXyuvBZ9mlR1RkOTAe
fSfV29cAci7lXal34EB0koLf4MIa2J2ZXa52kQOs7dT5sFgjUNAd2xHfxAHG
V0tz3HIdFJilD16XloFXwcETauPrwcxIeC7SRgbYPItMlVwudF3IjQiKlwF7
Ib0xq/SNsCuiipSvlYGbb7cICcdugr529bEaMVnosvvd1uyBKXhwjA5Y2ciC
zqtTT9iHAJ52Pmg6fFoWHAQX9KgwM9CT8cvJrpGFgZr1BoX3zSG888r5FCEa
8ouWKSU3WkBlVGDfVh4N7tvNphKmLEE6KS1XNpKGlsZyEw3GCkyNV4WdLqNB
LCp2hHPWGjhLDAXJ5TQwX1wLGhKs4dM8d/utChokArWsT1+2htgaK41yREO4
xafe2VvW0Ozk0fCrmoaOs6emx4qt4ffAVGXBSxo22d39i/piDefyREvN3+N4
RHs43RYMuKew79p/oIEfxF39yIaBNaHyF90/0hCjsk0l3o6BVlh+IKyHBqt9
70LW72JgWZOpZH4fDY8jectSAxjI/x60S/0HDdwnzLoztxiIaT6xRX+Yhsm0
6WTPewy4PD6lv3mEhj+qbWptshmYPZko5PqThoblk5mcEgaspLMzEyZo2Diu
6p/RxIDSSEHK9UkavjVaBia0MjDY8iQia4oGt6Mh20O7GEhIq3Osm6GhztUs
2rafAY/Ixs2ts7geFaOd3O8MrBW0avfO0RCrNyCh9YsBEeadzOg8rkfpOkp2
moH2Vb0zCws0ZAV/wr+IDPwL8lOAOg==
        "]]},
      Annotation[#, "Charting`Private`Tag$24687#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 5}, {-20, 30}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.714792266016348*^9, 
  3.7147922981165514`*^9},ExpressionUUID->"89a542a9-864c-4686-9ae1-\
3f565b370b53"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 3.7132360275922284`*^9}, 
   3.714062161219843*^9, {3.7140621964035716`*^9, 3.71406221565207*^9}, {
   3.71425727771903*^9, 
   3.714257277799074*^9}},ExpressionUUID->"75ef795d-ed94-4422-9b08-\
0272bd75d947"],

Cell[TextData[{
 "Give the ",
 StyleBox["exact",
  FontSlant->"Italic"],
 " numerical value of the following expressions:"
}], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.714351693841385*^9}},ExpressionUUID->"e52c2591-20a0-4aa0-bb1c-\
2853d9700d70"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"cos", " ", 
   FractionBox[
    RowBox[{"2", "\[Pi]"}], "3"]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"a2005721-1d08-455a-bc6a-f6d8b176f7d0"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.714351735978551*^9}},ExpressionUUID->"78e6ec2c-46e7-48a3-8d67-\
c6eab4e14237"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"sin", "(", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "4"]}], ")"}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"10f89a58-95cd-482a-9a13-504167f7ad3b"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.7143517743939805`*^9}},ExpressionUUID->"9a3db587-0502-463c-891c-\
1176e4063d8d"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"tan", " ", 
   FractionBox[
    RowBox[{"7", "\[Pi]"}], "6"]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"511ca8ca-4ade-44b5-b1b9-e8452f15032f"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.714351797609931*^9}},ExpressionUUID->"5c6f93cd-8264-452a-80ec-\
0aa8dbaaf6c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714784416286566*^9, 
  3.7147844180507107`*^9}},ExpressionUUID->"82ae961b-3309-43b9-a798-\
b43f708d7805"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"cos", " ", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "3"]}], "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], 
  TraditionalForm]],ExpressionUUID->"b48cdb9f-c91f-4e33-b01f-30b369f72815"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.714351735978551*^9}, {3.7147845897118435`*^9, 
   3.7147845993691406`*^9}},ExpressionUUID->"75190c37-d215-461f-bb8f-\
76b46b3149f8"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"sin", "(", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], ")"}], "=", 
   RowBox[{"-", 
    FractionBox[
     SqrtBox["2"], "2"]}]}], 
  TraditionalForm]],ExpressionUUID->"dc06920a-70a6-45cd-914b-4119d588f4b6"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.7143517743939805`*^9}, {3.714784608432623*^9, 
   3.7147846138904886`*^9}},ExpressionUUID->"a930c693-42c2-40f4-83f5-\
cb0f7ed79f09"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"tan", " ", 
    FractionBox[
     RowBox[{"7", "\[Pi]"}], "6"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "/", "2"}], 
     RowBox[{
      SqrtBox["3"], "/", "2"}]], "=", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], "=", 
     FractionBox[
      SqrtBox["3"], "3"]}]}]}], 
  TraditionalForm]],ExpressionUUID->"9628c274-7e07-4acc-86a8-ec657412bcc7"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 3.7142554520723405`*^9}, {3.7143516653686123`*^9, 
   3.714351797609931*^9}, {3.7147846174646854`*^9, 
   3.714784671225215*^9}},ExpressionUUID->"45d0403e-69f9-4a1b-8607-\
461ddee8dfd4"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 281, 4, 101, "Title", "ExpressionUUID" -> \
"e2a663f3-a3f2-468a-9734-fec8e8cef455"],
Cell[CellGroupData[{
Cell[886, 30, 620, 11, 115, "Chapter", "ExpressionUUID" -> \
"d03d63b9-f7d1-4e9a-802a-29845d2ecc45"],
Cell[1509, 43, 593, 10, 49, "Text", "ExpressionUUID" -> \
"ca0b7995-c377-4221-be97-d8cfa2ba7a30"],
Cell[CellGroupData[{
Cell[2127, 57, 207, 4, 70, "Section", "ExpressionUUID" -> \
"6a4b2b36-0d04-4260-87db-8dc550817df8"],
Cell[2337, 63, 690, 10, 30, "Text", "ExpressionUUID" -> \
"f4c37571-1782-4d4b-8e04-af54ea2ebeea"],
Cell[3030, 75, 1005, 18, 45, "Text", "ExpressionUUID" -> \
"1c9c113a-3528-4511-80c5-7d6fa38cc0e4"],
Cell[4038, 95, 554, 10, 49, "Text", "ExpressionUUID" -> \
"2a2c265b-e003-4bce-b3db-7157f0ade4cd"],
Cell[CellGroupData[{
Cell[4617, 109, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"39a66b88-c47e-4418-99d3-2b1c8d7303c9"],
Cell[4778, 114, 452, 12, 30, "Text", "ExpressionUUID" -> \
"dcb9072c-3c9f-4d30-a012-1979efa045e4"],
Cell[5233, 128, 925, 25, 32, "Text", "ExpressionUUID" -> \
"bdbdd5db-077b-447d-8a72-64a28c273eb9"],
Cell[6161, 155, 549, 15, 30, "Text", "ExpressionUUID" -> \
"693e376a-60ee-4337-aa73-b3f48c28f321"],
Cell[CellGroupData[{
Cell[6735, 174, 354, 11, 44, "Input", "ExpressionUUID" -> \
"48897f7f-510c-4e10-afde-6e84ac293be7"],
Cell[7092, 187, 8777, 163, 243, "Output", "ExpressionUUID" -> \
"d5474044-01e0-4594-a61e-b395854104b9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15930, 357, 158, 3, 70, "Section", "ExpressionUUID" -> \
"b28852a6-bd74-45f0-a95e-16ecea01a043"],
Cell[16091, 362, 1647, 40, 36, "Text", "ExpressionUUID" -> \
"7e3e2465-f8d9-4e4b-805b-86f3d05fa56a"],
Cell[CellGroupData[{
Cell[17763, 406, 1184, 23, 30, "ItemNumbered", "ExpressionUUID" -> \
"9fc643e1-f142-4f9e-a888-e83f0f8a3c19"],
Cell[18950, 431, 1281, 25, 30, "ItemNumbered", "ExpressionUUID" -> \
"843884b2-4b9d-49c0-94d6-f43669d4461b"],
Cell[20234, 458, 1281, 25, 30, "ItemNumbered", "ExpressionUUID" -> \
"784638cc-8df2-42ae-adbc-b8113b57945a"],
Cell[21518, 485, 1304, 25, 30, "ItemNumbered", "ExpressionUUID" -> \
"74ae2943-2458-486b-a5f1-f8a67755ccb9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22859, 515, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"006ecde4-e925-4795-8acc-ac09a12d4b43"],
Cell[CellGroupData[{
Cell[23044, 522, 1319, 25, 40, "ItemNumbered", "ExpressionUUID" -> \
"5f04b1fe-5046-4be6-8c0c-740cbfa17b1c"],
Cell[24366, 549, 1359, 25, 34, "ItemNumbered", "ExpressionUUID" -> \
"c93a68c2-09ac-47aa-bbfc-c9702c914080"],
Cell[25728, 576, 1352, 25, 32, "ItemNumbered", "ExpressionUUID" -> \
"7f6bfa96-7957-4947-9313-5fd30e6159f3"],
Cell[27083, 603, 1398, 26, 58, "ItemNumbered", "ExpressionUUID" -> \
"52b71f1d-0b7c-4907-9948-d97ca28c05d8"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28542, 636, 156, 3, 70, "Section", "ExpressionUUID" -> \
"2fdc451e-de16-4ae4-b75a-e4563f7c66a7"],
Cell[28701, 641, 1459, 30, 47, "Text", "ExpressionUUID" -> \
"ef2f02a7-af4b-4573-b9dc-12637035a58a",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[30185, 675, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"242e5402-30de-4021-b980-2d3f0876a528"],
Cell[30346, 680, 293, 6, 30, "Text", "ExpressionUUID" -> \
"015cff35-61d2-426c-8915-03383c4754b0"],
Cell[30642, 688, 351, 10, 67, "Input", "ExpressionUUID" -> \
"6a552fbd-17c5-4c1b-9c69-f9a588a8a715"],
Cell[CellGroupData[{
Cell[31018, 702, 318, 9, 47, "Input", "ExpressionUUID" -> \
"e11582f8-a4ec-4b1d-806a-8cef1d8c1f14"],
Cell[31339, 713, 329, 10, 48, "Output", "ExpressionUUID" -> \
"a3bbfa5a-78bc-41a4-8c03-6dbf1d030173"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31705, 728, 318, 9, 47, "Input", "ExpressionUUID" -> \
"aa0f7d47-a729-421b-99ab-fba2c32deb89"],
Cell[32026, 739, 296, 10, 48, "Output", "ExpressionUUID" -> \
"6c12d494-7fc9-440e-bec5-57d7e21f4518"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32383, 756, 208, 4, 70, "Section", "ExpressionUUID" -> \
"f1c852ca-ab5a-43f2-8c9a-5e7755a061bf"],
Cell[32594, 762, 1577, 35, 49, "Text", "ExpressionUUID" -> \
"3950af2a-52ba-4954-ad74-d40d8150aa1f"],
Cell[CellGroupData[{
Cell[34196, 801, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"2854bd76-3384-4fe3-b5ba-7aca60a6bdbb"],
Cell[34359, 806, 170, 3, 30, "Text", "ExpressionUUID" -> \
"0ad61283-0ade-43ea-a4d7-66bab6b3acdf"],
Cell[CellGroupData[{
Cell[34554, 813, 405, 11, 30, "Input", "ExpressionUUID" -> \
"9da07e30-48aa-4040-b169-9be3dc5b4cb4"],
Cell[34962, 826, 19729, 343, 139, "Output", "ExpressionUUID" -> \
"0d4b38e0-d8f1-4eef-a87f-11bc68f04c91"]
}, Open  ]],
Cell[54706, 1172, 393, 10, 30, "Text", "ExpressionUUID" -> \
"1ce838d9-be03-46ad-87e8-2ff45dc35a4e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55148, 1188, 155, 3, 70, "Section", "ExpressionUUID" -> \
"c073e0fd-c6e5-4f37-98ff-30997aa2d956"],
Cell[55306, 1193, 413, 12, 30, "Text", "ExpressionUUID" -> \
"842f65f0-6259-4161-8293-97a3a749ac07"],
Cell[55722, 1207, 507, 14, 32, "Text", "ExpressionUUID" -> \
"9ed1b0a8-e883-41f4-8770-b2e0da2c8253"],
Cell[CellGroupData[{
Cell[56254, 1225, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"f5c74c01-3592-4a84-a956-d7a5da814fdd"],
Cell[56415, 1230, 1564, 50, 47, "Text", "ExpressionUUID" -> \
"e3f3f7eb-f9ed-4ab0-bb5c-abb20d6595b7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58028, 1286, 257, 4, 70, "Section", "ExpressionUUID" -> \
"d2ec5041-3f61-4ae8-8bcc-02c6dd814afa"],
Cell[58288, 1292, 889, 17, 30, "Text", "ExpressionUUID" -> \
"1420c7a4-a1a3-4361-91a6-56bd79902e51"],
Cell[59180, 1311, 1062, 22, 32, "Text", "ExpressionUUID" -> \
"c52db8da-e799-4ff8-8cb2-2da33e9e5303"],
Cell[CellGroupData[{
Cell[60267, 1337, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"a179073b-ea23-4d7a-a785-013b7fe7f02f"],
Cell[60428, 1342, 1588, 52, 39, "Text", "ExpressionUUID" -> \
"f2e21425-9fba-442d-b5ff-8d824f1f7f7c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62065, 1400, 156, 3, 70, "Section", "ExpressionUUID" -> \
"5cd38511-aaaa-471e-ac17-065388224828"],
Cell[62224, 1405, 745, 19, 51, "Text", "ExpressionUUID" -> \
"b6d95d74-515d-490f-943d-ed8dbad62f1c"],
Cell[CellGroupData[{
Cell[62994, 1428, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"5f0ae938-3588-4145-aacf-205eae602a57"],
Cell[63157, 1433, 172, 3, 30, "Text", "ExpressionUUID" -> \
"2afefba1-cff2-4c09-b1b8-392beaa99a5f"],
Cell[CellGroupData[{
Cell[63354, 1440, 385, 12, 33, "Input", "ExpressionUUID" -> \
"3ebc1d57-4110-4e3b-8461-ddc8e27ee4e5"],
Cell[63742, 1454, 10387, 189, 238, "Output", "ExpressionUUID" -> \
"9d88704b-f032-458e-b5ae-40294e728d3e"]
}, Open  ]],
Cell[74144, 1646, 838, 22, 30, "Text", "ExpressionUUID" -> \
"93feaaaf-89f1-4a58-8b3d-4dc471fe3973"],
Cell[CellGroupData[{
Cell[75007, 1672, 1297, 41, 33, "Input", "ExpressionUUID" -> \
"311900b0-7a16-469a-b4f5-c88faa08ed93"],
Cell[76307, 1715, 13419, 240, 245, "Output", "ExpressionUUID" -> \
"89a542a9-864c-4686-9ae1-3f565b370b53"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89787, 1962, 279, 5, 70, "Section", "ExpressionUUID" -> \
"75ef795d-ed94-4422-9b08-0272bd75d947"],
Cell[90069, 1969, 976, 17, 30, "Text", "ExpressionUUID" -> \
"e52c2591-20a0-4aa0-bb1c-2853d9700d70"],
Cell[CellGroupData[{
Cell[91070, 1990, 1083, 19, 41, "ItemNumbered", "ExpressionUUID" -> \
"78e6ec2c-46e7-48a3-8d67-c6eab4e14237"],
Cell[92156, 2011, 1111, 20, 42, "ItemNumbered", "ExpressionUUID" -> \
"9a3db587-0502-463c-891c-1176e4063d8d"],
Cell[93270, 2033, 1083, 19, 41, "ItemNumbered", "ExpressionUUID" -> \
"5c6f93cd-8264-452a-80ec-0aa8dbaaf6c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94390, 2057, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"82ae961b-3309-43b9-a798-b43f708d7805"],
Cell[CellGroupData[{
Cell[94573, 2064, 1173, 22, 41, "ItemNumbered", "ExpressionUUID" -> \
"75190c37-d215-461f-bb8f-76b46b3149f8"],
Cell[95749, 2088, 1215, 24, 46, "ItemNumbered", "ExpressionUUID" -> \
"a930c693-42c2-40f4-83f5-cb0f7ed79f09"],
Cell[96967, 2114, 1349, 30, 55, "ItemNumbered", "ExpressionUUID" -> \
"45d0403e-69f9-4a1b-8607-461ddee8dfd4"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

